#include <ansi_c.h>
#include <analysis.h>
#include <cvirte.h>		
#include <userint.h>
#include "Convolution.h"

#define VECLEN	2000
#define XMAX	10.0
#define XMIN   -10.0

static int panelHandle;
double MyVec[VECLEN];
double MyDist[VECLEN];
double dx = (XMAX-XMIN)/VECLEN;
double ConvVec[2*VECLEN];
/**********************************************************************/
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "Convolution.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}
/**********************************************************************/
int CVICALLBACK QuitCallback (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
	{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
	}
	return 0;
}
/**********************************************************************/
int CVICALLBACK MakeWave (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int N;
int P;
	switch (event)
	{
		case EVENT_COMMIT:
			DeleteGraphPlot (panelHandle, PANEL_GRAPH, -1, VAL_IMMEDIATE_DRAW);
			GetCtrlVal (panelHandle, PANEL_NOC, &N);
			GetCtrlVal (panelHandle, PANEL_PHASE, &P);
			SinePattern (VECLEN, 1.0, P?90.0:0.0, N, MyVec);
			PlotWaveform (panelHandle, PANEL_GRAPH, MyVec, VECLEN, VAL_DOUBLE, 1.0, 0.0, XMIN, dx, VAL_THIN_LINE, VAL_NO_POINT, VAL_SOLID, 1, VAL_RED);
			break;
	}
	return 0;
}
/**********************************************************************/
int CVICALLBACK MakeDist (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
double D;
int k;
	switch (event)
	{
		case EVENT_COMMIT:
			DeleteGraphPlot (panelHandle, PANEL_GRAPH2, -1, VAL_IMMEDIATE_DRAW);
			GetCtrlVal (panelHandle, PANEL_DIST, &D);
			for(k=0; k<VECLEN; k++)
				{
				MyDist[k] = 1.0/(sqrt(D*D + (dx*k+XMIN)*(dx*k+XMIN)));
				}
			PlotWaveform (panelHandle, PANEL_GRAPH2, MyDist, VECLEN, VAL_DOUBLE, 1.0, 0.0, XMIN, dx, VAL_THIN_LINE, VAL_NO_POINT, VAL_SOLID, 1, VAL_RED);
			MakeConv (0, 0, EVENT_COMMIT, 0, 0, 0);
			break;
	}
	return 0;
}
/**********************************************************************/ 
int CVICALLBACK MakeConv (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
	{
		case EVENT_COMMIT:
			DeleteGraphPlot (panelHandle, PANEL_GRAPH3, -1, VAL_IMMEDIATE_DRAW);
			Convolve (MyVec, VECLEN, MyDist, VECLEN, ConvVec);
			PlotWaveform (panelHandle, PANEL_GRAPH3, ConvVec+VECLEN/2, VECLEN, VAL_DOUBLE, 1.0, 0.0, XMIN, dx, VAL_THIN_LINE, VAL_NO_POINT, VAL_SOLID, 1, VAL_RED);

			break;
	}
	return 0;
}
/**********************************************************************/
int CVICALLBACK ReadCursor (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
double x,y;
	switch (event)
	{
		case EVENT_COMMIT:
			GetGraphCursor (panel, control, 1, &x, &y);
			SetGraphCursor (panel, PANEL_GRAPH, 1, x, 0.0);
			SetGraphCursor (panel, PANEL_GRAPH2, 1, x, 0.0);
			SetGraphCursor (panel, PANEL_GRAPH3, 1, x, 0.0);
			break;
	}
	return 0;
}
/**********************************************************************/
