#include <analysis.h>
#include <cvirte.h>		
#include <userint.h>
#include "FFT-1d.h"

static int panelHandle;

#define	VECLEN	(1024*128) 

double MyTimeWave[VECLEN];
double MyFreqWave[VECLEN];

/***************************************************************************/
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "FFT-1d.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}
/***************************************************************************/
int CVICALLBACK QuitCallback (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
	{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
	}
	return 0;
}
/***************************************************************************/
int CVICALLBACK SetFreq (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
double Freq;
static int PlotHandaleT;
static int PlotHandaleF;

double	FFTx[VECLEN];
double 	FFTy[VECLEN];
double 	Phase[VECLEN];

	switch (event)
	{
		case EVENT_VAL_CHANGED:
			GetCtrlVal (panelHandle, PANEL_FREQ, &Freq);
			SinePattern (VECLEN, 1.0, 0.0, Freq, MyTimeWave);
			if (PlotHandaleT)
				DeleteGraphPlot (panelHandle, PANEL_GRAPHT, PlotHandaleT, VAL_IMMEDIATE_DRAW);
			PlotHandaleT = PlotY (panelHandle, PANEL_GRAPHT, MyTimeWave, VECLEN, VAL_DOUBLE, VAL_THIN_LINE, VAL_NO_POINT, VAL_SOLID, 1, VAL_YELLOW);

			Copy1D (MyTimeWave, VECLEN, FFTx);
			ReFFT (FFTx, FFTy, VECLEN);
			ToPolar1D (FFTx, FFTy, VECLEN, MyFreqWave, Phase);
			LinEv1D (MyFreqWave, VECLEN, 2.0/VECLEN, 0.0, MyFreqWave);
			
			
			if (PlotHandaleF)
				DeleteGraphPlot (panelHandle, PANEL_GRAPHF, PlotHandaleF, VAL_IMMEDIATE_DRAW);
			PlotHandaleF = PlotY (panelHandle, PANEL_GRAPHF, MyFreqWave, 101, VAL_DOUBLE, VAL_THIN_LINE, VAL_NO_POINT, VAL_SOLID, 1, VAL_YELLOW);
			break;
	}
	return 0;
}
/***************************************************************************/






















