#include <ansi_c.h>
#include <utility.h>
#include <cvirte.h>		
#include <userint.h>
#include "StringRead.h"

static int panelHandle;
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "StringRead.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}

int CVICALLBACK check (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int i;
	static char temp;
	static char str[128];
	
	switch (event)
		{
		case EVENT_TIMER_TICK:
			temp = inp(0x378);
			if (temp & (1<<7)) return 0;
			for(i=0; 1; i++)
				{
				str[i] = inp(0x378);
				if(!str[i]) break;
				while (!(inp(0x378) & (1<<7)));
				while (inp(0x378) & (1<<7));
				}
			SetCtrlVal (panelHandle, PANEL_STRING, str);
			Delay(0.1);
			break;
		}
	return 0;
}
