#include <ansi_c.h>
#include <utility.h>
#include <cvirte.h>		
#include <userint.h>
#include "StringWrite.h"

static int panelHandle;

int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "StringWrite.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}

int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}


int CVICALLBACK send (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int i;
	char str[128];
	switch (event)
		{
		case EVENT_COMMIT:
			GetCtrlVal (panelHandle, PANEL_STRING, str);
			for(i=0; 1; i++)
				{
				outp(0x378, str[i] & ~(1<<7));
				Delay(0.01);
				outp(0x378, str[i] | (1<<7));
				Delay(0.01);
				if(!str[i]) break;
				}		
			break;
		}
	return 0;
}
