#include <utility.h>
#include <cvirte.h>		/* Needed if linking in external compiler; harmless otherwise */
#include <userint.h>
#include "SpeakerButton.h"
#include "Speaker.h"

static int panelHandle;
/*=====================================================================*/
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)	/* Needed if linking in external compiler; harmless otherwise */
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "SpeakerButton.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	//InitPointer();
	RunUserInterface ();
	return 0;
}
/*=====================================================================*/
int CVICALLBACK quit (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}
/*=====================================================================*/
int CVICALLBACK on (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
double f;
	switch (event)
		{
		case EVENT_COMMIT:
			SpeakerOn(0);
			break;
		case EVENT_LEFT_CLICK:
			GetCtrlVal (panelHandle, PANEL_FREQ, &f);
			SetFreq(f);
			SpeakerOn(1);
			break;	
		}
	return 0;
}
/*=====================================================================*/
