#include <utility.h>
#include <cvirte.h>		
#include <userint.h>
#include "MTE.h"

static int panelHandle;
static int gExiting = 0;  /* flag to indicate user is exiting */
//static int CVICALLBACK ThreadFunction1 (void *functionData);

/***************************************************************************/
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "MTE.uir", PANEL)) < 0)
		return -1;
	DisplayPanel (panelHandle);
	RunUserInterface ();
	DiscardPanel (panelHandle);
	return 0;
}
/***************************************************************************/
int CVICALLBACK QuitCallback (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			gExiting = 1;
			QuitUserInterface (0);
			break;
		case EVENT_LEFT_DOUBLE_CLICK:

			break;
		}
	return 0;
}
/***************************************************************************/
int CVICALLBACK Start1 (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int K;
	switch (event)
		{
		case EVENT_COMMIT:
			for (K=0; 1; K++)
				{
				SetCtrlVal (panelHandle, PANEL_CNT1, K%100);
				Delay(0.5);
				}
				
			break;
		case EVENT_LEFT_DOUBLE_CLICK:

			break;
		}
	return 0;
}
/***************************************************************************/
static int CVICALLBACK TrFunction (void *functionData)
{
	int K;
	for (K=0; !gExiting; K++)
		{
		SetCtrlVal (panelHandle, PANEL_CNT2, K%100);
		Delay(0.2);
		}
	return 0;
}
/***************************************************************************/
int CVICALLBACK Start2 (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	static int threadFunctionId = 0;
	switch (event)
		{
		case EVENT_COMMIT:
			gExiting = 0;
			threadFunctionId = 0;
			CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE,
                                   TrFunction, NULL, &threadFunctionId);
			
			
			break;
		case EVENT_RIGHT_CLICK:
			gExiting = 1;
			CmtWaitForThreadPoolFunctionCompletion (DEFAULT_THREAD_POOL_HANDLE,
                                            threadFunctionId,
                                            OPT_TP_PROCESS_EVENTS_WHILE_WAITING);
			CmtReleaseThreadPoolFunctionID (DEFAULT_THREAD_POOL_HANDLE, threadFunctionId);
			
			break;
		}
	return 0;
}
/***************************************************************************/
