#include "LowLevelDriver64.h"
/*********************************************************************/
/*                                SPEAKER                            */
/*-------------------------------------------------------------------*/
/*    Task           : Control of Internal Speaker                   */
/*                   : 										         */
/*-------------------------------------------------------------------*/
/*    Author         : Flaxer Eli                                    */
/*    Developed on   :  01/05/2001                                   */
/*    Last update    :  10/04/2017                                   */
/*********************************************************************/
void SetFreq(double f)
  {
  #define BF 1.19318e6
  unsigned char lo, hi;
  int N = (BF/f);
  
  lo = (unsigned char) N;
  hi = (unsigned char) (N >> 8) ;
  outp(0x43, 0xB6);
  outp(0x42, lo);
  outp(0x42, hi);
  }
/************************************************************************/
void SpeakerOn(int x)
  {
  if (x)
	outp(0x61, inp(0x61) | 0x03);
  else
	outp(0x61, inp(0x61) & ~0x03);
  }
/************************************************************************/
