/*****************************************************************************/
/*                                 UM245SppLib.C                             */
/*---------------------------------------------------------------------------*/
/*    Task           :  SPP Device Emulation Library for UM245R Module       */
/*---------------------------------------------------------------------------*/
/*    Author         :  Flaxer Eli - Flaxer Engineering Solutions            */
/*    Email          :  eli@flaxer.net										 */
/*---------------------------------------------------------------------------*/
/*    Developed on   :  01/05/2008                                           */
/*    Last update    :  15/05/2008                                           */
/*****************************************************************************/

#include <utility.h>
/*******************************************/
#define	PORTADR	0x378


#define	WRn		(1<<2)		// C2
#define	RDn		(1<<3)		// C3
#define	RSTn	(1<<1)		// C1

#define	DIRn	(1<<5)		// C5

#define	RXFn	(1<<4)		// S4
#define	TXEn	(1<<5)		// S5

#define	IDLE	0x00
#define	DIR_IN	1
#define	DIR_OUT	0


/*******************************************/
#define	TIMEOUTERR	1000

/*******************************************/
int		DATAADR = PORTADR;
int		STATADR = PORTADR+1;
int		CTRLADR = PORTADR+2;

int		CtrlReg;
int		DataReg;
/*******************************************/
void SetData(int Data)
{
  outp(DATAADR, Data);
}
/*******************************************/
int GetData()
{
  return (inp(DATAADR));
}
/*******************************************/
int IsRXF()
{
  return(inp(STATADR) & RXFn);	
}
/*******************************************/
int IsTXE()
{
  return(inp(STATADR) & TXEn);	
}
/*******************************************/
void InitCTRL(void)
{
  CtrlReg = IDLE;
  outp(CTRLADR, CtrlReg);
}
/*******************************************/
void SetWR(int x)
{
  if (x)	
	CtrlReg |= WRn;
  else
	CtrlReg &= ~WRn;
  
  outp(CTRLADR, CtrlReg);
}
/*******************************************/
void SetRD(int x)
{
  if (!x)	
	CtrlReg |= RDn;
  else
	CtrlReg &= ~RDn;
  
  outp(CTRLADR, CtrlReg);
}
/*******************************************/
void SetRST(int x)
{
  if (!x)	
	CtrlReg |= RSTn;
  else
	CtrlReg &= ~RSTn;
  
  outp(CTRLADR, CtrlReg);
}
/*******************************************/
void SetDIR(int x)
{
  if (x)	
	CtrlReg |= DIRn;
  else
	CtrlReg &= ~DIRn;
  
  outp(CTRLADR, CtrlReg);
}
/*******************************************/
int WriteByte(int Data)
{
  int Inx = TIMEOUTERR;	
  while (IsTXE())
	  if (!Inx--) return (-1);
  
  SetDIR(DIR_OUT);
  SetWR(1);	  
  SetData(Data);
  SetWR(0);
  SetDIR(DIR_OUT);
  return (0);
}
/*******************************************/
int ReadByte()
{
  int Data;
  SetDIR(DIR_IN);
  SetRD(0);	  
  Data = GetData();
  SetRD(1);
  SetDIR(DIR_OUT);
  return (Data);
}
/*******************************************/
