/*****************************************************************************/
/*                                 UM245Tester.C                             */
/*---------------------------------------------------------------------------*/
/*    Task           :  Main GUI Program for Testing the FTDI UM245R Module  */
/*---------------------------------------------------------------------------*/
/*    Author         :  Flaxer Eli - Flaxer Engineering Solutions            */
/*    Email          :  eli@flaxer.net										 */
/*---------------------------------------------------------------------------*/
/*    Developed on   :  01/05/2008                                           */
/*    Last update    :  15/05/2008                                           */
/*****************************************************************************/
#include <windows.h>
#include <ansi_c.h>
#include <utility.h>
#include <cvirte.h>		
#include <userint.h>
#include "UM245Tester.h"
#include "UM245SppLib.h"
#include "UM245UsbLib.h" 

static int 			panelHandle;
static FT_HANDLE	ftHandle;
static FT_STATUS	ftStatus;

/******************************************************************************/
int main (int argc, char *argv[])
{
	if (InitCVIRTE (0, argv, 0) == 0)
		return -1;	/* out of memory */
	if ((panelHandle = LoadPanel (0, "UM245Tester.uir", PANEL)) < 0)
		return -1;
	
	InitCTRL();
	FLAX_GetFT_devInfoList();
	ftStatus = FT_Open(0, &ftHandle);
	DisplayPanel (panelHandle);
	RunUserInterface ();
	FT_Close(ftHandle);
	free(FT_devInfo);
	DiscardPanel (panelHandle);
	return 0;
}
/******************************************************************************/
int CVICALLBACK QuitPanel (int panel, int event, void *callbackData,
		int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_GOT_FOCUS:

			break;
		case EVENT_LOST_FOCUS:

			break;
		case EVENT_CLOSE:
			QuitUserInterface (0);
			break;
		}
	return 0;
}
/******************************************************************************/
int CVICALLBACK QuitCallback (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
			QuitUserInterface (0);
			break;
		}
	return 0;
}
/******************************************************************************/
int CVICALLBACK DataOut (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int i;
	char temp;
	int x;
	int Err;

	switch (event)
		{
		case EVENT_COMMIT:
			for (temp=0, i=7; i>=0; i--)
				{
				temp <<= 1;
				GetCtrlVal (panelHandle, PANEL_DO0+i, &x);
				temp |= x;
				}
			Err = WriteByte(temp);
			if (Err)
				Beep();
			break;
		}
	return 0;
}
/******************************************************************************/ 
int CVICALLBACK DataIn (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int i;
	char temp;
	switch (event)
		{
		case EVENT_TIMER_TICK:
			if (IsRXF())
				return 0;	
			temp = ReadByte();
			for (i=0; i<8; i++)
				SetCtrlVal (panelHandle, PANEL_DI0+i, temp & (1<<i));
			break;
		}
	return 0;
}
/******************************************************************************/
int CVICALLBACK UsbDataOut (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int i;
	char temp;
	int x;

	FT_STATUS ftStatus;
	DWORD EventDWord;
	DWORD TxBytes;
	DWORD RxBytes;
	DWORD BytesTransmited;
	char TxBuffer[256];

	switch (event)
		{
		case EVENT_COMMIT:
			for (temp=0, i=7; i>=0; i--)
				{
				temp <<= 1;
				GetCtrlVal (panelHandle, PANEL_USBDO0+i, &x);
				temp |= x;
				}
			TxBuffer[0]=temp;
			FT_Write(ftHandle,TxBuffer,1,&BytesTransmited);
			break;
		}
	return 0;
}
/******************************************************************************/ 
int CVICALLBACK UsbDataIn (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	int i;
	char temp;
	
	FT_STATUS ftStatus;
	DWORD EventDWord;
	DWORD TxBytes;
	DWORD RxBytes;
	DWORD BytesReceived;
	char RxBuffer[256];
	
	switch (event)
		{
		case EVENT_TIMER_TICK:
			FT_GetStatus(ftHandle,&RxBytes,&TxBytes,&EventDWord);
			if (RxBytes > 0) 
				{
				FT_Read(ftHandle,RxBuffer,RxBytes,&BytesReceived);
				temp = RxBuffer[0];
				for (i=0; i<8; i++)
					SetCtrlVal (panelHandle, PANEL_USBDI0+i, temp & (1<<i));
				}
			break;
		}
	return 0;
}
/******************************************************************************/
int CVICALLBACK FESweb (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
	{
		case EVENT_COMMIT:
			LaunchExecutable ("explorer.exe http://www.fes.co.il");
			break;
	}
	return 0;
}

/******************************************************************************/
