/*****************************************************************************/
/*                                 UM245UsbLib.C                             */
/*---------------------------------------------------------------------------*/
/*    Task           :  USB Communication Functions for FTDI UM245R Module   */
/*---------------------------------------------------------------------------*/
/*    Author         :  Flaxer Eli - Flaxer Engineering Solutions            */
/*    Email          :  eli@flaxer.net										 */
/*---------------------------------------------------------------------------*/
/*    Developed on   :  01/05/2008                                           */
/*    Last update    :  15/05/2008                                           */
/*****************************************************************************/

#include <ansi_c.h>

#include "FTD2XX.h"


FT_DEVICE_LIST_INFO_NODE*	FT_devInfo;
DWORD 						FT_numDevs;

/*****************************************************************************/
int FLAX_GetFT_devInfoList()
{
  FT_STATUS ftStatus;
  
  // create the device information list
  ftStatus = FT_CreateDeviceInfoList(&FT_numDevs);
  if (ftStatus != FT_OK)
	return(ftStatus);	
  
  // allocate storage for list based on numDevs
  if (FT_numDevs != 0)
	  free(FT_devInfo);
  FT_devInfo = (FT_DEVICE_LIST_INFO_NODE*)malloc(sizeof(FT_DEVICE_LIST_INFO_NODE)*FT_numDevs);
  
  // get the device information list
  ftStatus = FT_GetDeviceInfoList(FT_devInfo, &FT_numDevs);
  if (ftStatus != FT_OK)
     return(ftStatus);
  
  return(FT_OK);
}
/*****************************************************************************/



